/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.util.impl;

import com.ibm.hwmca.fw.util.Trace;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class HMCTraceLogHandler
extends Handler {
    public HMCTraceLogHandler(Logger logger) {
        this.setFormatter(new Formatter(){

            public String format(LogRecord record) {
                return this.formatMessage(record);
            }
        });
        this.setLevelToMatch(logger);
    }

    private void setLevelToMatch(Logger logger) {
        logger.setLevel(Level.ALL);
    }

    public void publish(LogRecord record) {
        String msg;
        String traceMask;
        block12: {
            if (!this.isLoggable(record)) {
                return;
            }
            int hmcLevel = this.loggingToHMCLevel(record.getLevel());
            if (hmcLevel > 3) {
                return;
            }
            traceMask = hmcLevel == 1 ? "XTLGUNKT" : (hmcLevel == 2 ? "XTLGUNKF" : "XTLGUNKD");
            try {
                msg = this.getFormatter().format(record);
                if (record.getSourceClassName() == null) break block12;
                try {
                    Class<?> containingClass;
                    Class<?> sourceClass = Class.forName(record.getSourceClassName());
                    while ((containingClass = sourceClass.getDeclaringClass()) != null) {
                        sourceClass = containingClass;
                    }
                    Field maskField = sourceClass.getDeclaredField("TRACE_MASK");
                    if (Modifier.isStatic(maskField.getModifiers())) {
                        String s;
                        maskField.setAccessible(true);
                        Object value = maskField.get(null);
                        if (value instanceof String && (s = (String)value).length() == 7) {
                            traceMask = s + (char)(hmcLevel == 1 ? 84 : (hmcLevel == 2 ? 70 : 68));
                        }
                    }
                }
                catch (Exception e) {}
            }
            catch (Exception e) {
                this.reportError(null, e, 5);
                return;
            }
        }
        try {
            Trace.trace(traceMask, msg);
            Throwable e = record.getThrown();
            if (e != null) {
                Trace.trace(traceMask, e);
            }
        }
        catch (Exception e) {
            this.reportError(null, e, 1);
        }
    }

    private int loggingToHMCLevel(Level level) {
        if (level == Level.SEVERE || level == Level.WARNING) {
            return 1;
        }
        if (level == Level.FINE || level == Level.CONFIG) {
            return 2;
        }
        return 3;
    }

    public void flush() {
    }

    public void close() throws SecurityException {
    }
}

